'==========================================================================
'
' Author.......: Raffaele Chiatto
'
' WebSite......: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================

Option Explicit

Dim objSWbemLocator, objSWbemServices, objServices, Associator, Rtn, BlnRtn, SvcName

SvcName = "isactrl" 
Set objSWbemLocator = CreateObject("WbemScripting.SWbemLocator")
Set objSWbemServices = objSWbemLocator.ConnectServer("", "root\CIMV2","" ,"")
Set objServices = objSWbemServices.Get("Win32_Service.Name=""" & SvcName & """")

StopService(objServices)
wscript.echo
StartService(objServices)


Function StopService(objService)
  StopDependentServices(objService.Name)
  Wscript.Sleep 5000
  wscript.echo "Stopping " & objService.Name
    Rtn = objService.StopService(objService.Name)
    If Rtn = 3 then StopDependentServices(objService.Name)
    If Rtn <> 0 then
      Wscript.echo CheckReq(Rtn, objService.Name)
      Exit Function
    End if
  Wscript.Sleep 2000
End Function
 

Function StartService(objService)
  wscript.echo "Starting " & objService.Name
  Rtn = objService.StartService(objService.Name)
    If Rtn <> 0 then
      Wscript.echo CheckReq(Rtn, objService.Name)
    End if
  Wscript.Sleep 1000
  StartDependentServices(objService.Name)
End Function
 

Function StopDependentServices(strServiceName)
  For Each Associator In objSWbemServices.AssociatorsOf("Win32_Service.Name=""" & strServiceName & """", "Win32_DependentService",, "Dependent")
    If (Associator.StartMode = "Auto") and (Associator.State = "Running") then
      wscript.echo "Stopping dependent service: " & Associator.Name
      Rtn = Associator.StopService
      If Rtn = 3 then StopDependentServices(Associator.Name)
      If Rtn <> 0 Then
        Wscript.echo CheckReq(Rtn, Associator.Name)
        Exit Function
      End If
    End If
  Next
End Function
 

Function StartDependentServices(strServiceName)
  For Each Associator In objSWbemServices.AssociatorsOf("Win32_Service.Name=""" & strServiceName & """", "Win32_DependentService",, "Dependent")
    If (Associator.StartMode = "Auto") and (Associator.State = "Stopped") then
      wscript.echo "Starting dependent service: " & Associator.Name
      Rtn = Associator.StartService
      If Rtn <> 0 Then
        Wscript.echo CheckReq(Rtn, Associator.Name)
        Exit Function
      End If
    End If
  Next
End Function 

Function CheckReq(Error, Service)

  Dim objSvc
  Select Case Error
  Case 0 
    CheckReq = "The request was accepted."
  Case 1 
    CheckReq = "The request is not supported."
  Case 2 
    CheckReq = "The user did not have the necessary access."
  Case 3 
    CheckReq = "The service cannot be stopped because other services that are running are dependent on it."
  Case 4 
    CheckReq = "The requested control code is not valid, or it is unacceptable to the service."
  Case 5 
    Set objSvc = objSWbemServices.Get("Win32_BaseService.Name=""" & Service & """")
    CheckReq = "The requested control code cannot be sent to the service because the service state is set to '" & objSvc.State & "'"
  Case 6 
    CheckReq = "The service has not been started."
  Case 7 
    CheckReq = "The service did not respond to the start request in a timely fashion."
  Case 8 
    CheckReq = "Unknown failure when starting the service."
  Case 9 
    CheckReq = "The directory path to the service executable file was not found."
  Case 10 
    CheckReq = "The service is already running."
  Case 11 
    CheckReq = "The database to add a new service is locked."
  Case 12 
    CheckReq = "A dependency for which this service relies on has been removed from the system."
  Case 13 
    CheckReq = "The service failed to find the service needed from a dependent service."
  Case 14 
    CheckReq = "The service has been disabled from the system."
  Case 15 
    CheckReq = "The service does not have the correct authentication to run on the system."
  Case 16 
    CheckReq = "This service is being removed from the system."
  Case 17 
    CheckReq = "There is no execution thread for the service."
  Case 18 
    CheckReq = "There are circular dependencies when starting the service."
  Case 19 
    CheckReq = "There is a service running under the same name."
  Case 20 
    CheckReq = "There are invalid characters in the name of the service."
  Case 21 
    CheckReq = "Invalid parameters have been passed to the service."
  Case 22 
    CheckReq = "The account which this service is to run under is either invalid or lacks the permissions to run the service."
  Case 23 
    CheckReq = "The service exists in the database of services available from the system."
  Case 24 
    CheckReq = "The service is currently paused in the system."
  Case Else 
    CheckReq = "I don't know WTF happened: RTN = " & Cstr(Error)
  End Select

End Function
